/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yollo.dmlreforged.common.items.ItemDataModel;
import com.yollo.dmlreforged.common.mobmetas.MobMetaData;
import com.yollo.dmlreforged.core.container.SimulationChamberContainer;
import com.yollo.dmlreforged.core.util.Animation;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import com.yollo.dmlreforged.core.util.MathHelper;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SimulationChamberScreen
extends AbstractContainerScreen<SimulationChamberContainer> {
    private HashMap<String, Animation> animationList;
    private HashMap<String, String> simulationText = new HashMap();
    private Level level;
    private ItemStack currentDataModel = ItemStack.f_41583_;
    private static final ResourceLocation base = new ResourceLocation("dmlreforged", "textures/gui/simulation_chamber_base.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("dmlreforged", "textures/gui/default_gui.png");

    public SimulationChamberScreen(SimulationChamberContainer container, Inventory playerInv, Component component) {
        super((AbstractContainerMenu)container, playerInv, component);
        this.animationList = new HashMap();
        this.level = playerInv.f_35978_.f_19853_;
    }

    protected void m_7286_(PoseStack pose, float pPartialTick, int pMouseX, int pMouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int topStart = top - 39;
        int spacing = 12;
        MobMetaData data = DataModelHelper.getMobMetaData(((SimulationChamberContainer)this.m_6262_()).getDataModel());
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)base);
        this.m_93228_(pose, left - 20, top - 36, 0, 0, 216, 141);
        this.m_93228_(pose, left - 41, top - 36, 0, 141, 18, 18);
        int energyBarHeight = MathHelper.ensureRange((int)((float)((SimulationChamberContainer)this.f_97732_).data.m_6413_(1) / (float)(((SimulationChamberContainer)this.f_97732_).data.m_6413_(2) - data.getSimulationTickCost()) * 87.0f), 0, 87);
        int energyBarOffset = 87 - energyBarHeight;
        this.m_93228_(pose, left + 183, top + 12 + energyBarOffset, 25, 141, 7, energyBarHeight);
        if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) != 4) {
            int dataBarHeight = MathHelper.ensureRange((int)((float)DataModelHelper.getCurrentTierSimulationCountWithKills(((SimulationChamberContainer)this.m_6262_()).getDataModel()) / (float)DataModelHelper.getTierRoof(((SimulationChamberContainer)this.m_6262_()).getDataModel()) * 87.0f), 0, 87);
            int dataBarOffset = 87 - dataBarHeight;
            this.m_93228_(pose, left - 14, top + 12 + dataBarOffset, 18, 141, 7, dataBarHeight);
        } else {
            this.m_93228_(pose, left - 14, top + 12, 18, 141, 7, 87);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)defaultGui);
        this.m_93228_(pose, left + 0, top + 111, 0, 0, 176, 90);
        if (this.dataModelChanged()) {
            this.resetAnimations();
        }
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        ArrayList<TranslatableComponent> tooltip = new ArrayList<TranslatableComponent>();
        int energyStored = ((SimulationChamberContainer)this.f_97732_).data.m_6413_(1);
        int maxEnergy = ((SimulationChamberContainer)this.f_97732_).data.m_6413_(2);
        int x = pMouseX - this.getGuiLeft();
        int y = pMouseY - this.getGuiTop();
        if (11 <= y && y < 100) {
            if (-15 <= x && x < -6) {
                if (!((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41619_()) {
                    if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) != 4) {
                        tooltip.add(new TranslatableComponent("dmlreforged.gui.simulation_chamber.collected", new Object[]{DataModelHelper.getCurrentTierSimulationCountWithKills(((SimulationChamberContainer)this.m_6262_()).getDataModel()), DataModelHelper.getTierRoof(((SimulationChamberContainer)this.m_6262_()).getDataModel())}));
                    } else {
                        tooltip.add(new TranslatableComponent("dmlreforged.gui.simulation_chamber.max_tier"));
                    }
                } else {
                    tooltip.add(new TranslatableComponent("dmlreforged.gui.simulation_chamber.missing"));
                }
                this.m_96597_(pose, tooltip, pMouseX + 2, pMouseY + 2);
            } else if (182 <= x && x < 191) {
                tooltip.add(new TranslatableComponent("dmlreforged.gui.energy.energystored", new Object[]{f.format(energyStored), f.format(maxEnergy)}));
                if (!((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41619_()) {
                    MobMetaData meta = DataModelHelper.getMobMetaData(((SimulationChamberContainer)this.m_6262_()).getDataModel());
                    tooltip.add(new TranslatableComponent("dmlreforged.gui.simulation_chamber.drain", new Object[]{f.format(meta.getSimulationTickCost())}));
                }
                this.m_96597_(pose, tooltip, pMouseX - 90, pMouseY - 16);
            }
        }
        int leftTopConsole = left - 11;
        if (!(((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41720_() instanceof ItemDataModel)) {
            lines = new Component[]{new TranslatableComponent("dmlreforged.gui.simulation_chamber.insert"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.to_begin")};
            Animation a1 = this.getAnimation("pleaseInsert1");
            Animation a2 = this.getAnimation("pleaseInsert2");
            this.animateString(pose, lines[0], a1, null, 1, false, leftTopConsole, topStart + spacing, 0xFFFFFF);
            this.animateString(pose, lines[1], a2, a1, 1, false, leftTopConsole, topStart + spacing * 2, 0xFFFFFF);
        } else if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) == 0) {
            lines = new Component[]{new TextComponent("Insufficient data in model"), new TextComponent("please insert a basic model"), new TextComponent("or better ")};
            Animation insufData = this.getAnimation("insufData1");
            Animation insufData2 = this.getAnimation("insufData2");
            Animation insufData3 = this.getAnimation("insufData3");
            this.animateString(pose, lines[0], insufData, null, 1, false, leftTopConsole, topStart + spacing, 0xFFFFFF);
            this.animateString(pose, lines[1], insufData2, insufData, 1, false, leftTopConsole, topStart + spacing * 2, 0xFFFFFF);
            this.animateString(pose, lines[2], insufData3, insufData2, 1, false, leftTopConsole, topStart + spacing * 3, 0xFFFFFF);
        } else {
            if (DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) == 4) {
                this.m_93228_(pose, leftTopConsole + 6, top + 48, 18, 141, 7, 87);
            } else {
                int collectedData = DataModelHelper.getCurrentTierSimulationCountWithKills(((SimulationChamberContainer)this.m_6262_()).getDataModel());
                int tierRoof = DataModelHelper.getTierRoof(((SimulationChamberContainer)this.m_6262_()).getDataModel());
                int experienceBarHeight = (int)((float)collectedData / (float)tierRoof * 87.0f);
                int experienceBarOffset = 87 - experienceBarHeight;
                this.m_93228_(pose, leftTopConsole + 6, top + 48 + experienceBarOffset, 18, 141, 7, experienceBarHeight);
            }
            SimulationChamberScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.tiers.tier", new Object[]{DataModelHelper.getTierName(((SimulationChamberContainer)this.m_6262_()).getDataModel(), false)}), (int)leftTopConsole, (int)(topStart + spacing), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)("Iterations: " + f.format(DataModelHelper.getTotalSimulationCount(((SimulationChamberContainer)this.m_6262_()).getDataModel()))), (int)leftTopConsole, (int)(topStart + spacing * 2), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)("Pristine chance: " + DataModelHelper.getPristineChance(((SimulationChamberContainer)this.m_6262_()).getDataModel()) + "%"), (int)leftTopConsole, (int)(topStart + spacing * 3), (int)0xFFFFFF);
        }
        this.drawConsoleText(pose, spacing);
    }

    private void drawConsoleText(PoseStack pose, int spacing) {
        int leftStart = this.getGuiLeft();
        int topStart = this.getGuiTop() + 14;
        if (((SimulationChamberContainer)this.m_6262_()).getDataModel().m_41619_() || DataModelHelper.getTier(((SimulationChamberContainer)this.m_6262_()).getDataModel()) == 0) {
            this.animateString(pose, (Component)new TextComponent("_"), this.getAnimation("blinkingUnderline"), null, 16, true, leftStart, topStart, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.m_6262_()).getPolymerClay().m_41619_() && ((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) == 0) {
            Component[] lines = new Component[]{new TextComponent("Cannot begin simulation"), new TextComponent("Missing polymer medium"), new TextComponent("_")};
            Animation a1 = this.getAnimation("inputSlotEmpty1");
            Animation a2 = this.getAnimation("inputSlotEmpty2");
            Animation a3 = this.getAnimation("blinkingUnderline1");
            this.animateString(pose, lines[0], a1, null, 1, false, leftStart, topStart, 0xFFFFFF);
            this.animateString(pose, lines[1], a2, a1, 1, false, leftStart, topStart + spacing, 0xFFFFFF);
            this.animateString(pose, lines[2], a3, a2, 16, true, leftStart, topStart + spacing * 2, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.m_6262_()).data.m_6413_(1) < 300 * DataModelHelper.getSimulationTickCost(((SimulationChamberContainer)this.m_6262_()).getDataModel()) && ((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) == 0) {
            Component[] lines = new Component[]{new TextComponent("Cannot begin simulation"), new TextComponent("System energy levels critical"), new TextComponent("_")};
            Animation a1 = this.getAnimation("lowEnergy1");
            Animation a2 = this.getAnimation("lowEnergy2");
            Animation a3 = this.getAnimation("blinkingUnderline2");
            this.animateString(pose, lines[0], a1, null, 1, false, leftStart, topStart, 0xFFFFFF);
            this.animateString(pose, lines[1], a2, a1, 1, false, leftStart, topStart + spacing, 0xFFFFFF);
            this.animateString(pose, lines[2], a3, a2, 16, true, leftStart, topStart + spacing * 2, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.m_6262_()).outputIsFull() || ((SimulationChamberContainer)this.m_6262_()).pristineIsFull() && ((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) == 0) {
            Component[] lines = new Component[]{new TextComponent("Cannot begin simulation"), new TextComponent("Output or pristine buffer is full"), new TextComponent("_")};
            Animation a1 = this.getAnimation("outputSlotFilled1");
            Animation a2 = this.getAnimation("outputSlotFilled2");
            Animation a3 = this.getAnimation("blinkingUnderline3");
            this.animateString(pose, lines[0], a1, null, 1, false, leftStart, topStart, 0xFFFFFF);
            this.animateString(pose, lines[1], a2, a1, 1, false, leftStart, topStart + spacing, 0xFFFFFF);
            this.animateString(pose, lines[2], a3, a2, 16, true, leftStart, topStart + spacing * 2, 0xFFFFFF);
        } else if (((SimulationChamberContainer)this.f_97732_).data.m_6413_(0) > 0) {
            this.updateSimulationText(((SimulationChamberContainer)this.m_6262_()).getDataModel(), ((SimulationChamberContainer)this.f_97732_).data.m_6413_(3));
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)(((SimulationChamberContainer)this.m_6262_()).data.m_6413_(0) + "%"), (int)(leftStart + 158), (int)140, (int)0x55FFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine1"), (int)leftStart, (int)topStart, (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine1Version"), (int)(leftStart + 102), (int)topStart, (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine2"), (int)leftStart, (int)(topStart + spacing), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine3"), (int)leftStart, (int)(topStart + spacing * 2), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine4"), (int)leftStart, (int)(topStart + spacing * 3), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine5"), (int)leftStart, (int)(topStart + spacing * 4), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine6"), (int)leftStart, (int)(topStart + spacing * 5), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine6Result"), (int)(leftStart + 118), (int)(topStart + spacing * 5), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("simulationProgressLine7"), (int)leftStart, (int)(topStart + spacing * 6), (int)0xFFFFFF);
            SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)this.getSimulationText("blinkingDots1"), (int)(this.getGuiLeft() + 109), (int)(topStart + spacing * 6), (int)0xFFFFFF);
        } else {
            this.animateString(pose, (Component)new TextComponent("_"), this.getAnimation("blinkingUnderline"), null, 16, true, leftStart, topStart + 49, 0xFFFFFF);
        }
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    private void resetAnimations() {
        this.animationList = new HashMap();
    }

    private boolean dataModelChanged() {
        if (ItemStack.m_41728_((ItemStack)this.currentDataModel, (ItemStack)((SimulationChamberContainer)this.m_6262_()).getDataModel())) {
            return false;
        }
        this.currentDataModel = ((SimulationChamberContainer)this.m_6262_()).getDataModel();
        return true;
    }

    private Animation getAnimation(String key) {
        if (this.animationList.containsKey(key)) {
            return this.animationList.get(key);
        }
        this.animationList.put(key, new Animation());
        return this.animationList.get(key);
    }

    private void animateString(PoseStack pose, Component string, Animation anim, Animation precedingAnim, int delay, boolean loop, int left, int top, int color) {
        String result;
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                result = anim.animate(string.getString(), delay, this.level.m_46467_(), loop);
                SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)result, (int)left, (int)top, (int)color);
            } else {
                return;
            }
        }
        result = anim.animate(string.getString(), delay, this.level.m_46467_(), loop);
        SimulationChamberScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)result, (int)left, (int)top, (int)color);
    }

    public String getSimulationText(String key) {
        if (this.simulationText.containsKey(key)) {
            return this.simulationText.get(key);
        }
        this.simulationText.put(key, "");
        return this.simulationText.get(key);
    }

    private String animate(Component string, Animation anim, @Nullable Animation precedingAnim, int delayInTicks, boolean loop, Level world) {
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                return anim.animate(string.getString(), delayInTicks, world.m_46467_(), loop);
            }
            return "";
        }
        return anim.animate(string.getString(), delayInTicks, world.m_46467_(), loop);
    }

    private void updateSimulationText(ItemStack stack, int succesInt) {
        boolean byproductSuccess = succesInt == 1;
        Component[] lines = new Component[]{new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.1"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.2"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.3", new Object[]{DataModelHelper.getTotalSimulationCount(stack) + 1}), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.4"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.5"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.6"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.7"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.8_" + (byproductSuccess ? "succeeded" : "failed")), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.9"), new TranslatableComponent("dmlreforged.gui.simulation_chamber.console.10")};
        String resultPrefix = byproductSuccess ? "\ufffda" : "\ufffdc";
        Animation aLine1 = this.getAnimation("simulationProgressLine1");
        Animation aLine1Version = this.getAnimation("simulationProgressLine1Version");
        Animation aLine2 = this.getAnimation("simulationProgressLine2");
        Animation aLine3 = this.getAnimation("simulationProgressLine3");
        Animation aLine4 = this.getAnimation("simulationProgressLine4");
        Animation aLine5 = this.getAnimation("simulationProgressLine5");
        Animation aLine6 = this.getAnimation("simulationProgressLine6");
        Animation aLine6Result = this.getAnimation("simulationProgressLine6Result");
        Animation aLine7 = this.getAnimation("simulationProgressLine7");
        Animation aLine8 = this.getAnimation("blinkingDots1");
        this.simulationText.put("simulationProgressLine1", this.animate(lines[0], aLine1, null, 1, false, this.level));
        this.simulationText.put("simulationProgressLine1Version", "\ufffd6" + this.animate(lines[1], aLine1Version, aLine1, 1, false, this.level));
        this.simulationText.put("simulationProgressLine2", this.animate(lines[2], aLine2, aLine1Version, 1, false, this.level));
        this.simulationText.put("simulationProgressLine3", this.animate(lines[3], aLine3, aLine2, 2, false, this.level));
        this.simulationText.put("simulationProgressLine4", this.animate(lines[4], aLine4, aLine3, 1, false, this.level));
        this.simulationText.put("simulationProgressLine5", this.animate(lines[5], aLine5, aLine4, 2, false, this.level));
        this.simulationText.put("simulationProgressLine6", this.animate(lines[6], aLine6, aLine5, 2, false, this.level));
        this.simulationText.put("simulationProgressLine6Result", this.animate((Component)new TextComponent(resultPrefix + lines[7].getString()), aLine6Result, aLine6, 2, false, this.level));
        this.simulationText.put("simulationProgressLine7", this.animate(lines[8], aLine7, aLine6Result, 1, false, this.level));
        this.simulationText.put("blinkingDots1", this.animate(lines[9], aLine8, aLine7, 8, true, this.level));
    }
}

